<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LibraryCategory extends Model 
{

    protected $table = 'library_category';
    public $timestamps = true;
    protected $fillable = array('parent_id', 'node_id', 'ordering', 'name');

    public function parentLibraryCategory()
    {
        return $this->belongsTo('App\Models\LibraryCategory', 'parent_id', 'id');
    }

    public function childLibraryCategories()
    {
        return $this->hasMany('App\Models\LibraryCategory', 'parent_id', 'id');
    }

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function libraryFileCategories()
    {
        return $this->hasMany('App\Models\LibraryFileCategory');
    }

}